function model = wsatnerv( A, varargin )
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
% debugoutput=1;
p = inputParser;                             % create object
p.FunctionName = 'wsatnerv';                 % set function name
p.addRequired('A', @(x) (isfloat(x)));
p.addParamValue('gridlength', 2^ceil(log2(sqrt(size(A,1)))), @(x) (length(x)>0 & length(x)<3)); % nb of rows and columns in the grid
p.addParamValue('fixed',[],@(x) (isfloat(x)));
p.addParamValue('cnfPath','/tmp/',@(x) ischar(x));
p.addParamValue('solPath',pwd(),@(x) ischar(x));
p.addParamValue('useSolver','',@(x) any(strcmp(x,{'eval13MaxHS_noninteger',''})) );
p.addParamValue('fileStr','test',@ischar);
p.addParamValue('samePosi',1,@(x) isfloat(x));
p.parse (A, varargin{:});

fixed = ceil(p.Results.fixed);
cnfPath = p.Results.cnfPath;
if ~exist(cnfPath,'dir')
    error('The directory %s does not exist specify another and try again!',cnfPath);
end
solPath = p.Results.solPath;
if ~exist(solPath,'dir')
    error('The directory %s does not exist specify another and try again!',solPath);
end
if ~strcmp(solPath(end),'/')
    solPath = [solPath,'/'];
end
useSolver = p.Results.useSolver;
fileStr = p.Results.fileStr;
samePosi = single(p.Results.samePosi>0);
gridlength = ceil(p.Results.gridlength);
% gridlength = parameter.gridlength;
if(length(gridlength)>1)
    nb_rows = gridlength(1);
    nb_cols = gridlength(2);
else
    nb_rows = gridlength;
    nb_cols = gridlength;
end
gridpositions = nb_rows*nb_cols;
row_bits = ceil(log2(nb_rows));
col_bits = ceil(log2(nb_cols));
if ~isempty(fixed)
    minp = min(fixed(:,1));
    maxp = max(fixed(:,1));
    minpos = min(fixed(:,2));
    maxpos = max(fixed(:,2));
    if minp<1 || maxp>length(A) || minpos<1 || maxpos>gridpositions
        error('fixed points does not fit given nb points %i and gridposis %i',length(A),gridpositions);
    end
end
%% construct weights for the encoding (solve asymmetric assignments)
nb_samples = length(A);
W = A;

[asymRIdx,~] = find(triu(W,1)'~=tril(W));
[rIdx,~] = find(abs(W)>Inf & abs(W)<Inf);
wrIdx = [asymRIdx;rIdx];% wcIdx = [asymCIdx;cIdx];
if ~isempty(wrIdx)
    disp('Recompute asymmetric weighting given by A:');
    for i=1:nb_samples-1
        for j = i+1:nb_samples;
            if(W(i,j)~=W(j,i))
                if((W(i,j)>0 && W(j,i)<0)||(W(i,j)<0 && W(j,i)>0))
                    fprintf('asymmetric assignment for %i %i\n',i,j);
                    nv = W(i,j)+W(j,i);
                    W(i,j) = nv;
                    W(j,i) = nv;
                else
                    mv = mean([W(i,j),W(j,i)]);
                    W(i,j) = mv;
                    W(j,i) = mv;
                end
            end
        end
    end
end
W = tril(W)';
% sum(W(find(W>0)))
% sum(W(find(W<0)))
%  x=2;sum(W(x,W(x,:)>0),2)
%  x=2;sum(W(x,W(x,:)<0),2)
%% compute the encoding
nb_nns = length(find(W~=0));
nb_bits = col_bits+row_bits;
Vars.grid = [nb_rows,nb_cols];
% Bit variables to determine the position on the Grid
Vars.bitPos = arrayfun(@str2double,dec2bin(0:2^nb_bits-1))*2-1;
Vars.pointBits = cell2mat(arrayfun(@(i) i*nb_bits:-1:(i-1)*nb_bits+1,1:nb_samples,'uni',0)');
fprintf('%8i Bit variables: %8i...%8i\n',nb_samples*nb_bits,Vars.pointBits(1,end),Vars.pointBits(end,1));
if 0,
    useCombis = arrayfun(@str2double,dec2bin(0:2^nb_bits-1))*2-1;
    Vars.PtP = cell(nb_samples,gridpositions);
    ogb= ones(gridpositions,nb_bits);
    og = ones(1,gridpositions);
    for i=1:nb_samples
        useV = (i*nb_bits:-1:(i-1)*nb_bits+1);
        useVars = bsxfun(@times,useV,ogb);
        Vars.PtP(i,:) = mat2cell(useCombis(1:gridpositions,:).*useVars,og)';
    end
% fprintf('%8i Bit variables: %8i...%8i\n',nb_samples*nb_bits,Vars.PtP{1,end}(end),Vars.PtP{end,end}(1));
end
lastVar = nb_samples*nb_bits;
% CN Vars
Vars.CN = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(abs(W(i,otherIdx))>0);
    Vars.CN(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i CN  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.CN(Vars.CN>0)),max(Vars.CN(Vars.CN>0)),length(min(Vars.CN(Vars.CN>0)):max(Vars.CN(Vars.CN>0))));
% RN Vars
Vars.RN = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(abs(W(i,otherIdx))>0);
    Vars.RN(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i RN  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.RN(Vars.RN>0)),max(Vars.RN(Vars.RN>0)),length(min(Vars.RN(Vars.RN>0)):max(Vars.RN(Vars.RN>0))));
% DN Vars
Vars.DN = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(abs(W(i,otherIdx))>0);
    Vars.DN(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i DN  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.DN(Vars.DN>0)),max(Vars.DN(Vars.DN>0)),length(min(Vars.DN(Vars.DN>0)):max(Vars.DN(Vars.DN>0))));
% PR Vars
Vars.PR = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(W(i,otherIdx)<0);
    Vars.PR(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i PR  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.PR(Vars.PR>0)),max(Vars.PR(Vars.PR>0)),length(min(Vars.PR(Vars.PR>0)):max(Vars.PR(Vars.PR>0))));
% SC Vars
Vars.SC = zeros(nb_samples,nb_samples);
if samePosi, % if same position use probably less variables
    usePoints = nb_nns;
    for i=1:nb_samples
        otherIdx = i+1:nb_samples;
        useIdx = find(abs(W(i,otherIdx))>0);
        Vars.SC(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
        lastVar = lastVar+length(useIdx);
    end
else % if same position is not allowed we need variables for each pair of points
    usePoints = nb_samples*(nb_samples-0.5*nb_samples-0.5);
    for i=1:nb_samples
        otherIdx = i+1:nb_samples;
        Vars.SC(i,otherIdx) = lastVar+1:lastVar+length(otherIdx);
        lastVar = lastVar+length(otherIdx);
    end
end
fprintf('%8i SC  variables: |%8i...%8i|=%8i\n',usePoints,...
    min(Vars.SC(Vars.SC>0)),max(Vars.SC(Vars.SC>0)),length(min(Vars.SC(Vars.SC>0)):max(Vars.SC(Vars.SC>0))));
% SR Vars
Vars.SR = zeros(nb_samples,nb_samples);
if samePosi, % if same position use probably less variables
    for i=1:nb_samples
        otherIdx = i+1:nb_samples;
        useIdx = find(abs(W(i,otherIdx))>0);
        Vars.SR(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
        lastVar = lastVar+length(useIdx);
    end
else % if same position is not allowed we need variables for each pair of points
    for i=1:nb_samples
        otherIdx = i+1:nb_samples;
        Vars.SR(i,otherIdx) = lastVar+1:lastVar+length(otherIdx);
        lastVar = lastVar+length(otherIdx);
    end
end
fprintf('%8i SR  variables: |%8i...%8i|=%8i\n',usePoints,...
    min(Vars.SR(Vars.SR>0)),max(Vars.SR(Vars.SR>0)),length(min(Vars.SR(Vars.SR>0)):max(Vars.SR(Vars.SR>0))));
% AC Vars
Vars.AC = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(abs(W(i,otherIdx))>0);
    Vars.AC(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i AC  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.AC(Vars.AC>0)),max(Vars.AC(Vars.AC>0)),length(min(Vars.AC(Vars.AC>0)):max(Vars.AC(Vars.AC>0))));
% AR Vars
Vars.AR = zeros(nb_samples,nb_samples);
for i=1:nb_samples
    otherIdx = i+1:nb_samples;
    useIdx = find(abs(W(i,otherIdx))>0);
    Vars.AR(i,otherIdx(useIdx)) = lastVar+1:lastVar+length(useIdx);
    lastVar = lastVar+length(useIdx);
end
fprintf('%8i AR  variables: |%8i...%8i|=%8i\n',nb_nns,...
    min(Vars.AR(Vars.AR>0)),max(Vars.AR(Vars.AR>0)),length(min(Vars.AR(Vars.AR>0)):max(Vars.AR(Vars.AR>0))));
% EQj Vars
Vars.EQj = zeros(nb_bits,nb_samples,nb_samples);
if samePosi, % if same position use probably less variables
    for i=1:nb_samples-1
        otherIdx = i+1:nb_samples;
        useIdx = find(abs(W(i,otherIdx))>0);
        for j=otherIdx(useIdx)
            Vars.EQj(1:nb_bits,i,j) = lastVar+1:lastVar+nb_bits;
            lastVar = lastVar+nb_bits;
        end
    end
else % if same position is not allowed we need variables for each pair of points
    for i=1:nb_samples-1
        otherIdx = i+1:nb_samples;% useIdx = find(abs(W(i,otherIdx))>0);
        for j=otherIdx
            Vars.EQj(1:nb_bits,i,j) = lastVar+1:lastVar+nb_bits;
            lastVar = lastVar+nb_bits;
        end
    end
end
fprintf('%8i EQj variables: |%8i...%8i|=%8i\n',usePoints*nb_bits,...
    min(Vars.EQj(Vars.EQj>0)),max(Vars.EQj(Vars.EQj>0)),length(min(Vars.EQj(Vars.EQj>0)):max(Vars.EQj(Vars.EQj>0))));
% Fi Vars
useBits = [2:col_bits,col_bits+2:nb_bits];% for given pair of points look for flip in smaller bits
Vars.Fi = zeros(length(useBits),nb_samples,nb_samples);
for j=1:length(useBits)
    FixyVars = lastVar+1:lastVar+2*nb_nns;
    Vars.Fi(j,W~=0) = FixyVars(1:length(FixyVars)/2);
    Vars.Fi(j,:,:) = squeeze(Vars.Fi(j,:,:))';
    Vars.Fi(j,W~=0) = FixyVars(length(FixyVars)/2+1:end);
    lastVar = lastVar+2*nb_nns;
end
fprintf('%8i Fi  variables: |%8i...%8i|=%8i\n',2*nb_nns*length(useBits),...
    min(Vars.Fi(Vars.Fi>0)),max(Vars.Fi(Vars.Fi>0)),length(min(Vars.Fi(Vars.Fi>0)):max(Vars.Fi(Vars.Fi>0))));
% Ai and Bi Vars
Vars.Ai = zeros(length(useBits),nb_samples,nb_samples);
Vars.Bi = zeros(length(useBits),nb_samples,nb_samples);
AiVars = lastVar+1:lastVar+length(useBits)*nb_nns;
lastVar = lastVar+length(useBits)*nb_nns;
BiVars = lastVar+1:lastVar+length(useBits)*nb_nns;
for j=1:length(useBits)
    Vars.Ai(j,W~=0) = AiVars(j*nb_nns-nb_nns+1:j*nb_nns);%Vars.Ai(j,:,:) = squeeze(Vars.Ai(j,:,:))';
    Vars.Bi(j,W~=0) = BiVars(j*nb_nns-nb_nns+1:j*nb_nns);%Vars.Bi(j,:,:) = squeeze(Vars.Bi(j,:,:))';
end
fprintf('%8i Ai  variables: |%8i...%8i|=%8i\n',nb_nns*length(useBits),...
    min(Vars.Ai(Vars.Ai>0)),max(Vars.Ai(Vars.Ai>0)),length(min(Vars.Ai(Vars.Ai>0)):max(Vars.Ai(Vars.Ai>0))));
fprintf('%8i Bi  variables: |%8i...%8i|=%8i\n',nb_nns*length(useBits),...
    min(Vars.Bi(Vars.Bi>0)),max(Vars.Bi(Vars.Bi>0)),length(min(Vars.Bi(Vars.Bi>0)):max(Vars.Bi(Vars.Bi>0))));
%% soft clauses
% recall
[i,j] = find((W>0 & abs(W)<Inf));
nb_pwr = length(i);
recall_SC = zeros(nb_pwr,5);
for x=1:nb_pwr
    recall_SC(x,1:end-1) = [W(i(x),j(x)),Vars.RN(i(x),j(x)),Vars.CN(i(x),j(x)),Vars.DN(i(x),j(x))];
end
% precision
[i,j] = find((W<0 & abs(W)>-Inf));
nb_pwp = length(i);
precision_SC = zeros(nb_pwp,3);
for x=1:nb_pwp
    precision_SC(x,1:end-1) = [abs(W(i(x),j(x))),Vars.PR(i(x),j(x))];
end
nb_soft_clauses = nb_pwr+nb_pwp;% nb_soft_clauses = size(recall_SC,1)+size(precision_SC,1);
hard_weight = sum([recall_SC(:,1);precision_SC(:,1)])+1;
%% hard clauses
% recallHC
[i,j] = find(W==Inf);
recall_HC = cell2mat(arrayfun(@(x) [hard_weight,Vars.RN(i(x),j(x)),Vars.CN(i(x),j(x)),Vars.DN(i(x),j(x)),0],1:length(i),'uni',0)');
% recall_HC = [hard_weight*ones(length(i),1),Vars.RN(i,j),Vars.CN(i,j),Vars.DN(i,j),zeros(length(i),1)];
% precisionHC
[i,j] = find(W==-Inf);
precision_HC = cell2mat(arrayfun(@(x) [hard_weight,Vars.PR(i(x),j(x)),0],1:length(i),'uni',0)');
% precision_HC = [hard_weight*ones(length(i),1),Vars.PR(i,j),zeros(length(i),1)];
%% open the wcnf file for writing
nb_CN_HC = nb_nns*3;
nb_RN_HC = nb_nns*3;
nb_DN_HC = nb_nns*3;
[i_pr,j_pr] = find(W<0);
nb_PR_HC = length(i_pr)*3;
nb_sc_c = col_bits+1;
nb_SC_HC = usePoints*nb_sc_c;
nb_sr_c = row_bits+1;
nb_SR_HC = usePoints*nb_sr_c;
nb_ac_c = 2*(col_bits-1)+1;
nb_AC_HC = nb_nns*nb_ac_c;
nb_ar_c = 2*(row_bits-1)+1;
nb_AR_HC = nb_nns*nb_ar_c;
nb_eqj_c = nb_bits*4;
nb_EQj_HC = usePoints*nb_eqj_c;
allSB = cell(length(useBits),1);
for actBit=1:length(useBits)
    if actBit<col_bits
        LL = 1;
    else
        LL = col_bits+1;
    end
    acti=useBits(actBit);
    allSB{actBit} = LL:acti-1;
end
nb_fi_c = sum(cellfun(@(x) length(x)*4+2,allSB));
nb_Fi_HC = nb_nns*nb_fi_c;
allLB = cell(length(useBits),1);
for actBit=1:length(useBits)
    if actBit<col_bits
        UL = col_bits;
    else
        UL = nb_bits;
    end
    acti=useBits(actBit);
    allLB{actBit} = acti+1:UL;
end
nb_ai_c = sum(cellfun(@(x) length(x)+4,allLB));
nb_Ai_HC = nb_nns*nb_ai_c;
nb_Bi_HC = nb_nns*nb_ai_c;
if samePosi,nb_SP_HC = 0;else nb_SP_HC = usePoints;end
nb_encoding_hardclauses = nb_CN_HC+nb_RN_HC+nb_DN_HC+nb_PR_HC+nb_SC_HC+nb_SR_HC+nb_AC_HC+nb_AR_HC+nb_EQj_HC+nb_Fi_HC+nb_Ai_HC+nb_Bi_HC+nb_SP_HC;
nb_clauses = nb_soft_clauses+size(recall_HC,1)+size(precision_HC,1)+nb_encoding_hardclauses;
cnf_info=struct('maxWeight',hard_weight,'nb_clauses',nb_clauses,'nb_vars',max(Vars.Bi(Vars.Bi>0)), ...
                'nb_encoding_hardclauses',nb_encoding_hardclauses,'nb_softclauses',nb_soft_clauses, ...
                'nb_recall_softclauses',size(recall_SC,1),'nb_precision_softclauses',size(precision_SC,1), ...
                'nb_recall_hardclauses',size(recall_HC,1),'nb_precision_hardclauses',size(precision_HC,1),...
                'same_Posi_hardclauses',nb_SP_HC);
if isempty(fileStr)
    fileStr = sprintf('%ix%i_%s',nb_samples,gridpositions,useSolver);
end
str = sprintf('c\nc weighted Max SAT (wcnf) for %i samples for %i grid positions\nc\np wcnf %i %i %f\n',...
               nb_samples,gridpositions,cnf_info.nb_vars,cnf_info.nb_clauses,cnf_info.maxWeight);
fileEnding = '.wcnf';
cnffile = [cnfPath,fileStr,fileEnding];
fid = fopen(cnffile,'W');
if fid < 0
error('File open failed')
end
fwrite(fid,str);
% fixed points
zb = zeros(nb_bits,1);
ob = ones(nb_bits,1);
if ~isempty(fixed)
    disp('fixed positions given!');
    arrayfun(@(k) fprintf(fid,'%f %i %i\n',[ob.*hard_weight,[Vars.pointBits(fixed(k,1),:).*Vars.bitPos(fixed(k,2),:)]',zb]'),1:size(fixed,1));
end
if ~isempty(recall_SC)
str = sprintf('%s %s%s\n','%f',repmat('%i ',1,size(recall_SC,2)-2),'%i');% arrayfun(@(x) fprintf(fid,str,recall_SC(x,:)),1:size(recall_SC,1));
fprintf(fid,str,recall_SC');
end
if ~isempty(precision_SC)
str = sprintf('%s %s%s\n','%f',repmat('%i ',1,size(precision_SC,2)-2),'%i');
fprintf(fid,str,precision_SC');
end
if ~isempty(recall_HC)
str = sprintf('%s %s%s\n','%f',repmat('%i ',1,size(recall_HC,2)-2),'%i');
fprintf(fid,str,recall_HC');
end
if ~isempty(precision_HC)
str = sprintf('%s %s%s\n','%f',repmat('%i ',1,size(precision_HC,2)-2),'%i');
fprintf(fid,str,precision_HC');
end
% hard clauses for the encoding
% CN encoding {[nan,-SR(x,y),-AC(x,y),CN(x,y),0],[nan,-CN(x,y),SR(x,y),0],[nan,-CN(x,y),AC(x,y),0]};
[i,j] = find(W~=0);
for x=1:nb_nns
    fprintf(fid,'%f %i %i %i %i\n',hard_weight,-Vars.SR(i(x),j(x)),-Vars.AC(i(x),j(x)),Vars.CN(i(x),j(x)),0);
    fprintf(fid,'%f %i %i %i\n',[hard_weight,-Vars.CN(i(x),j(x)),Vars.SR(i(x),j(x)),0;...
                                 hard_weight,-Vars.CN(i(x),j(x)),Vars.AC(i(x),j(x)),0]');
end
% RN encoding {[nan,-SC(x,y),-AR(x,y),RN(x,y),0],[nan,-RN(x,y),AR(x,y),0],[nan,-RN(x,y),SC(x,y),0]};
for x=1:nb_nns
    fprintf(fid,'%f %i %i %i %i\n',hard_weight,-Vars.SC(i(x),j(x)),-Vars.AR(i(x),j(x)),Vars.RN(i(x),j(x)),0);
    fprintf(fid,'%f %i %i %i\n',[hard_weight,-Vars.RN(i(x),j(x)),Vars.AR(i(x),j(x)),0;...
                                 hard_weight,-Vars.RN(i(x),j(x)),Vars.SC(i(x),j(x)),0]');
end
% DN encoding {[nan,DN(x,y),-AR(x,y),-AC(x,y),0],[nan,-DN(x,y),AR(x,y),0],[nan,-DN(x,y),AC(x,y),0]};
for x=1:nb_nns
    fprintf(fid,'%f %i %i %i %i\n',hard_weight,-Vars.AR(i(x),j(x)),-Vars.AC(i(x),j(x)),Vars.DN(i(x),j(x)),0);
    fprintf(fid,'%f %i %i %i\n',[hard_weight,-Vars.DN(i(x),j(x)),Vars.AR(i(x),j(x)),0;...
                                 hard_weight,-Vars.DN(i(x),j(x)),Vars.AC(i(x),j(x)),0]');
end
% PR encoding {[hartRules;-Pr(x,y),-RN(x,y);-Pr(x,y),-CN(x,y);-Pr(x,y),-DN(x,y)]};
for x=1:length(i_pr)
    fprintf(fid,'%f %i %i %i\n',[hard_weight,-Vars.PR(i_pr(x),j_pr(x)),-Vars.RN(i_pr(x),j_pr(x)),0;...
                                 hard_weight,-Vars.PR(i_pr(x),j_pr(x)),-Vars.CN(i_pr(x),j_pr(x)),0;...
                                 hard_weight,-Vars.PR(i_pr(x),j_pr(x)),-Vars.DN(i_pr(x),j_pr(x)),0]');
end
% SC encoding
zcb = zeros(col_bits,1);
ocb = ones(col_bits,1);
str = sprintf('%s %s%s\n','%f %i %i',repmat('%i ',1,col_bits-1),'%i');
if samePosi, % if same position use probably less clauses
    for x=1:nb_nns    
        fprintf(fid,str,hard_weight,Vars.SC(i(x),j(x)),-Vars.EQj(1:col_bits,i(x),j(x))',0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*ocb,-ocb.*Vars.SC(i(x),j(x)),Vars.EQj(1:col_bits,i(x),j(x)),zcb]');
    end
else % if same position is not allowed we need clauses for each pair of points
    [r,c] = find(Vars.SC>0);
    for x=1:usePoints
        fprintf(fid,str,hard_weight,Vars.SC(r(x),c(x)),-Vars.EQj(1:col_bits,r(x),c(x))',0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*ocb,-ocb.*Vars.SC(r(x),c(x)),Vars.EQj(1:col_bits,r(x),c(x)),zcb]');
    end
end
% SR encoding
zrb = zeros(row_bits,1);
orb = ones(row_bits,1);
str = sprintf('%s %s%s\n','%f %i %i',repmat('%i ',1,row_bits-1),'%i');
if samePosi, % if same position use probably less clauses
    for x=1:nb_nns
        fprintf(fid,str,hard_weight,Vars.SR(i(x),j(x)),-Vars.EQj(col_bits+1:nb_bits,i(x),j(x))',0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*orb,-orb.*Vars.SR(i(x),j(x)),Vars.EQj(col_bits+1:nb_bits,i(x),j(x)),zrb]');
    end
else % if same position is not allowed we need clauses for each pair of points
    for x=1:usePoints
        fprintf(fid,str,hard_weight,Vars.SR(r(x),c(x)),-Vars.EQj(col_bits+1:nb_bits,r(x),c(x))',0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*orb,-orb.*Vars.SR(r(x),c(x)),Vars.EQj(col_bits+1:nb_bits,r(x),c(x)),zrb]');
    end
end
% AC encoding
firstHalfBits = 1:col_bits-1;
zcbm = zeros(col_bits-1,1);
ocbm = ones(col_bits-1,1);
str = sprintf('%s %s%s\n','%f %i %i',repmat('%i ',1,2*length(firstHalfBits)-1),'%i');
for x=1:nb_nns
    fprintf(fid,str,hard_weight,Vars.AC(i(x),j(x)),-Vars.Ai(firstHalfBits,i(x),j(x))',-Vars.Bi(firstHalfBits,i(x),j(x))',0);
    fprintf(fid,'%f %i %i %i\n',[hard_weight*ocbm,-ocbm.*Vars.AC(i(x),j(x)),Vars.Ai(1:col_bits-1,i(x),j(x)),zcbm;...
                                 hard_weight*ocbm,-ocbm.*Vars.AC(i(x),j(x)),Vars.Bi(1:col_bits-1,i(x),j(x)),zcbm]');
end
% AR encoding
lastHalfBits = col_bits:length(useBits);
orbm = ones(row_bits-1,1);
zrbm = zeros(row_bits-1,1);
str = sprintf('%s %s%s\n','%f %i %i',repmat('%i ',1,2*length(lastHalfBits)-1),'%i');
for x=1:nb_nns
    fprintf(fid,str,hard_weight,Vars.AR(i(x),j(x)),-Vars.Ai(lastHalfBits,i(x),j(x))',-Vars.Bi(lastHalfBits,i(x),j(x))',0);
    fprintf(fid,'%f %i %i %i\n',[hard_weight*orbm,-orbm.*Vars.AR(i(x),j(x)),Vars.Ai(lastHalfBits,i(x),j(x)),zrbm;...
                                 hard_weight*orbm,-orbm.*Vars.AR(i(x),j(x)),Vars.Bi(lastHalfBits,i(x),j(x)),zrbm]');
end
% EQj encoding
% zb = zeros(nb_bits,1);
% ob = ones(nb_bits,1);
if samePosi, % if same position use probably less clauses
    for x=1:nb_nns
%         fprintf(fid,'%f %i %i %i %i\n',[hard_weight*ob,-Vars.EQj(:,i(x),j(x)),flipud(-Vars.PtP{i(x),end}'),flipud( Vars.PtP{j(x),end}'),zb;...
%                                         hard_weight*ob,-Vars.EQj(:,i(x),j(x)),flipud( Vars.PtP{i(x),end}'),flipud(-Vars.PtP{j(x),end}'),zb;...
%                                         hard_weight*ob, Vars.EQj(:,i(x),j(x)),flipud( Vars.PtP{i(x),end}'),flipud( Vars.PtP{j(x),end}'),zb;...
%                                         hard_weight*ob, Vars.EQj(:,i(x),j(x)),flipud(-Vars.PtP{i(x),end}'),flipud(-Vars.PtP{j(x),end}'),zb]');
        fprintf(fid,'%f %i %i %i %i\n',[hard_weight*ob,-Vars.EQj(:,i(x),j(x)),flipud(-Vars.pointBits(i(x),:)'),flipud( Vars.pointBits(j(x),:)'),zb;...
                                        hard_weight*ob,-Vars.EQj(:,i(x),j(x)),flipud( Vars.pointBits(i(x),:)'),flipud(-Vars.pointBits(j(x),:)'),zb;...
                                        hard_weight*ob, Vars.EQj(:,i(x),j(x)),flipud( Vars.pointBits(i(x),:)'),flipud( Vars.pointBits(j(x),:)'),zb;...
                                        hard_weight*ob, Vars.EQj(:,i(x),j(x)),flipud(-Vars.pointBits(i(x),:)'),flipud(-Vars.pointBits(j(x),:)'),zb]');
    end
else % if same position is not allowed we need clauses for each pair of points
    for x=1:usePoints
        fprintf(fid,'%f %i %i %i %i\n',[hard_weight*ob,-Vars.EQj(:,r(x),c(x)),flipud(-Vars.pointBits(r(x),:)'),flipud( Vars.pointBits(c(x),:)'),zb;...
                                        hard_weight*ob,-Vars.EQj(:,r(x),c(x)),flipud( Vars.pointBits(r(x),:)'),flipud(-Vars.pointBits(c(x),:)'),zb;...
                                        hard_weight*ob, Vars.EQj(:,r(x),c(x)),flipud( Vars.pointBits(r(x),:)'),flipud( Vars.pointBits(c(x),:)'),zb;...
                                        hard_weight*ob, Vars.EQj(:,r(x),c(x)),flipud(-Vars.pointBits(r(x),:)'),flipud(-Vars.pointBits(c(x),:)'),zb]');
    end
end
% Fi encoding
bitPos = nb_bits:-1:1;
for x=1:nb_nns
    for actBit=1:length(useBits)
        smallerBits = allSB{actBit};
        lsb = length(smallerBits);
        osb = ones(lsb,1);
        zsb = zeros(lsb,1);
        
        str = sprintf('%s %s%s\n','%f %i',repmat('%i ',1,2*lsb),'%i');
        fprintf(fid,str,hard_weight,Vars.Fi(actBit,i(x),j(x)),Vars.pointBits(i(x),bitPos(smallerBits)),-Vars.pointBits(j(x),bitPos(smallerBits)),0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*osb,-Vars.Fi(actBit,i(x),j(x)).*osb,-Vars.pointBits(i(x),bitPos(smallerBits))',zsb;...
                                     hard_weight*osb,-Vars.Fi(actBit,i(x),j(x)).*osb, Vars.pointBits(j(x),bitPos(smallerBits))',zsb]');
        fprintf(fid,str,hard_weight,Vars.Fi(actBit,j(x),i(x)),-Vars.pointBits(i(x),bitPos(smallerBits)),Vars.pointBits(j(x),bitPos(smallerBits)),0);
        fprintf(fid,'%f %i %i %i\n',[hard_weight*osb,-Vars.Fi(actBit,j(x),i(x)).*osb, Vars.pointBits(i(x),bitPos(smallerBits))',zsb;...
                                     hard_weight*osb,-Vars.Fi(actBit,j(x),i(x)).*osb,-Vars.pointBits(j(x),bitPos(smallerBits))',zsb]');
%         fprintf(fid,str,hard_weight,Vars.Fi(actBit,i(x),j(x)),Vars.PtP{i(x),end}(bitPos(smallerBits)),-Vars.PtP{j(x),end}(bitPos(smallerBits)),0);
%         fprintf(fid,'%f %i %i %i\n',[hard_weight*osb,-Vars.Fi(actBit,i(x),j(x)).*osb,-Vars.PtP{i(x),end}(bitPos(smallerBits))',zsb;...
%                           hard_weight*osb,-Vars.Fi(actBit,i(x),j(x)).*osb, Vars.PtP{j(x),end}(bitPos(smallerBits))',zsb]');
%         fprintf(fid,str,hard_weight,Vars.Fi(actBit,j(x),i(x)),-Vars.PtP{i(x),end}(bitPos(smallerBits)),Vars.PtP{j(x),end}(bitPos(smallerBits)),0);
%         fprintf(fid,'%f %i %i %i\n',[hard_weight*osb,-Vars.Fi(actBit,j(x),i(x)).*osb, Vars.PtP{i(x),end}(bitPos(smallerBits))',zsb;...
%                           hard_weight*osb,-Vars.Fi(actBit,j(x),i(x)).*osb,-Vars.PtP{j(x),end}(bitPos(smallerBits))',zsb]');
    end
end
% Ai and Bi encoding
for x=1:nb_nns
    for actBit=1:length(useBits)%length(useHalfBits)
        largerBits = allLB{actBit};
        acti=useBits(actBit);%acti=useHalfBits(actBit);
        llb = length(largerBits);
        olb = ones(llb,1);
        zlb = zeros(llb,1);
        str = sprintf('%s %s%s\n','%f %i %i',repmat('%i ',1,llb),'%i %i %i');
        fprintf(fid,str,[hard_weight,-Vars.Ai(actBit,i(x),j(x)),Vars.EQj(acti,i(x),j(x)),-Vars.EQj(largerBits,i(x),j(x))',...
                              -Vars.pointBits(i(x),bitPos(acti)),Vars.Fi(actBit,i(x),j(x)),0]);
        fprintf(fid,'%f %i %i %i\n',[hard_weight,Vars.Ai(actBit,i(x),j(x)),-Vars.EQj(acti,i(x),j(x)),0;...
                                     hard_weight,Vars.Ai(actBit,i(x),j(x)),Vars.pointBits(i(x),bitPos(acti)),0;
                                     hard_weight,Vars.Ai(actBit,i(x),j(x)),-Vars.Fi(actBit,i(x),j(x)),0;...
                                     hard_weight*olb,Vars.Ai(actBit,i(x),j(x)).*olb,Vars.EQj(largerBits,i(x),j(x)),zlb]');
        fprintf(fid,str,[hard_weight,-Vars.Bi(actBit,i(x),j(x)),Vars.EQj(acti,i(x),j(x)),-Vars.EQj(largerBits,i(x),j(x))',...
                               Vars.pointBits(i(x),bitPos(acti)),Vars.Fi(actBit,j(x),i(x)),0]);
        fprintf(fid,'%f %i %i %i\n',[hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.EQj(acti,i(x),j(x)),0;...
                                     hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.pointBits(i(x),bitPos(acti)),0;...
                                     hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.Fi(actBit,j(x),i(x)),0;...
                                     hard_weight*olb,Vars.Bi(actBit,i(x),j(x)).*olb,Vars.EQj(largerBits,i(x),j(x)),zlb]');
%         fprintf(fid,str,[hard_weight,-Vars.Ai(actBit,i(x),j(x)),Vars.EQj(acti,i(x),j(x)),-Vars.EQj(largerBits,i(x),j(x))',...
%                               -Vars.PtP{i(x),end}(bitPos(acti)),Vars.Fi(actBit,i(x),j(x)),0]);
%         fprintf(fid,'%f %i %i %i\n',[hard_weight,Vars.Ai(actBit,i(x),j(x)),-Vars.EQj(acti,i(x),j(x)),0;...
%                                      hard_weight,Vars.Ai(actBit,i(x),j(x)),Vars.PtP{i(x),end}(bitPos(acti)),0;
%                                      hard_weight,Vars.Ai(actBit,i(x),j(x)),-Vars.Fi(actBit,i(x),j(x)),0;...
%                                      hard_weight*olb,Vars.Ai(actBit,i(x),j(x)).*olb,Vars.EQj(largerBits,i(x),j(x)),zlb]');
%         fprintf(fid,str,[hard_weight,-Vars.Bi(actBit,i(x),j(x)),Vars.EQj(acti,i(x),j(x)),-Vars.EQj(largerBits,i(x),j(x))',...
%                                Vars.PtP{i(x),end}(bitPos(acti)),Vars.Fi(actBit,j(x),i(x)),0]);
%         fprintf(fid,'%f %i %i %i\n',[hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.EQj(acti,i(x),j(x)),0;...
%                                      hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.PtP{i(x),end}(bitPos(acti)),0;...
%                                      hard_weight,Vars.Bi(actBit,i(x),j(x)),-Vars.Fi(actBit,j(x),i(x)),0;...
%                                      hard_weight*olb,Vars.Bi(actBit,i(x),j(x)).*olb,Vars.EQj(largerBits,i(x),j(x)),zlb]');
    end
end
if ~samePosi, % not the same position allowed
    disp('not on the same position!');
    for x=1:nb_samples
        otherIdx = x+1:nb_samples;
        fprintf(fid,'%f %i %i %i\n',[hard_weight*ones(length(otherIdx),1),-Vars.SC(x,otherIdx)',-Vars.SR(x,otherIdx)',zeros(length(otherIdx),1)]');
    end
end
fclose(fid);
disp(['CNF written to file ',cnffile]);
%% run the solver
if ~isempty(useSolver)
    mypath = mfilename('fullpath');
    mypath = mypath(1:end-8);
    solutionfile = [solPath,fileStr,'.sol'];
    switch useSolver,
        case{'eval13MaxHS_noninteger'}
            system([mypath,'./eval13MaxHS_noninteger ',cnffile,' > ',solutionfile]);
            disp('eval13MaxHS_noninteger maxsat finished!');
        otherwise
            error('unknown solver! BREAK');
    end
else
    fprintf('Run your solver with file %s\n',cnffile);
end
%% read the solution
if ~isempty(useSolver)
    disp(['Read the solution ',solutionfile]);
    model=struct('W',W,'Vars',{Vars},'cnf_info',{cnf_info},'cnfFile',cnffile,'solFile',solutionfile,'useSolver',useSolver);
    model.solution = wsatnerv_readSolution(solutionfile, model);
    model.Grid = construct_grid(gridlength,'rectangular');
    model.Map = zeros(nb_samples,prod(gridlength));
    for acti=1:nb_samples
        findSample = (model.solution.variables(model.Vars.pointBits(acti,:))>0)*2-1;
%     rightIdx = find(arrayfun(@(x) isequal(model.Vars.bitPos(x,:),findSample),1:gridpositions));
        model.Map(acti,arrayfun(@(x) isequal(model.Vars.bitPos(x,:),findSample),1:gridpositions)) = 1;  
%     findSample = model.solution.variables([model.Vars.PtP{acti,end}]);
%     rightIdx = find(cellfun(@(x) isequal(x,findSample),model.Vars.PtP(acti,:))>0);
%     model.Map(acti,rightIdx) = 1;
    end
else
    model=struct('W',W,'Vars',{Vars},'cnf_info',{cnf_info},'cnfFile',cnffile);
    model.Grid = construct_grid(gridlength,'rectangular');
end
end