function [ solution ] = wsatnerv_readSolution( solutionfile, varargin )
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here
p = inputParser;                             % create object
p.FunctionName = 'bsatnerv_readSolution';    % set function name
p.addRequired('solutionfile', @ischar);
p.addOptional('model',[], @isstruct);    
p.parse (solutionfile, varargin{:});
if ~exist(solutionfile,'file')
    error('The file %s does not exist specify another and try again!',solutionfile);
end
model = p.Results.model;
%% read the solution
[filepath, filename] = fileparts(solutionfile);

sStr = '';
notSatisfiedClauses = nan;
fid = fopen(solutionfile);
while 1
    tline = fgetl(fid);
    if(ischar(tline) & strcmp(tline(1:2), 's '))
        if tline>0
           sStr = tline(3:end);
        else
           sStr = nan;
        end
    end
    if(ischar(tline) & strcmp(tline(1:2),'o '))
        if tline>0
            notSatisfiedClauses = tline(3:end);
        else
            notSatisfiedClauses = nan;
        end
    end
    % Break if we hit end of file, or the start marker
    if ~ischar(tline)  ||  strcmp(tline(1:2), 'v ')
        if tline>0 
            mapping = str2num(tline(2:end));
        else
            mapping = nan;
        end
        break
    end
end
fclose(fid);
[~,cputime] = system(['tail -n ',num2str(1),' ',solutionfile]);
cputime = str2double(cputime(13:end));
notSatisfiedClauses = str2double(notSatisfiedClauses);

% disp(['CPU Time: ',num2str(cputime)]);
if notSatisfiedClauses>=0, %~isempty(notSatisfiedClauses)    
    disp([sStr,' nb of not satisfied clauses: ',num2str(notSatisfiedClauses)]);
end
solution = struct('info',sStr,'variables',mapping,'cputime',cputime,'notSatisfiedClauses',notSatisfiedClauses);
% if isfield(model,'encoding_vars')
%     [nb_samples,gridpositions] = size(model.encoding_vars.Point_to_Position);
%     if ~isnan(mapping)
%         Map = zeros(nb_samples,gridpositions);
%         for i=1:nb_samples
%             findSample = mapping([model.encoding_vars.Point_to_Position{i,end}]);%;
%             [~,rightIdx] = max(cellfun(@(x) length(intersect(x,findSample)),model.encoding_vars.Point_to_Position(i,:)));
%             Map(i,rightIdx) = 1;
%         end
%         if 0,
%         tri = nb_samples*(nb_samples-0.5*nb_samples-0.5);
%         trilMat = tril(ones(nb_samples),-1);
%         nbB = log2(gridpositions);
%         useHalfBits = [2:nbB/2,nbB/2+2:nbB];
%         lastPos = 0;
%         S.b = fliplr(reshape(mapping(lastPos+1:lastPos+nbB*nb_samples),nbB,nb_samples)');
%         lastPos = lastPos+nbB*nb_samples;            
%         S.EQj = reshape(mapping(lastPos+1:lastPos + tri*nbB),nbB,tri)';
%         lastPos = lastPos + tri*nbB;
%         S.Fi = nan(length(useHalfBits),nb_samples,nb_samples);
%         for j=1:length(useHalfBits)
%             FixyVars = mapping(lastPos+1:lastPos+2*tri);
%             S.Fi(j,trilMat==1) = FixyVars(1:length(FixyVars)/2);S.Fi(j,:,:) = squeeze(S.Fi(j,:,:))';
%             S.Fi(j,trilMat==1) = FixyVars(length(FixyVars)/2+1:end);
%             lastPos = lastPos+2*tri;
%         end
%         S.Ai = reshape(mapping(lastPos+1:lastPos+tri*length(useHalfBits)),tri,length(useHalfBits));
%         lastPos = lastPos + tri*length(useHalfBits);
%         S.Bi = reshape(mapping(lastPos+1:lastPos+tri*length(useHalfBits)),tri,length(useHalfBits));
%         lastPos = lastPos + tri*length(useHalfBits);
%         S.SC = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;       
%         S.AC = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;
%         S.SR = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;
%         S.AR = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;
%         S.CN = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;
%         S.RN = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%         lastPos = lastPos+tri;
%         if model.gridNeighbors==9
%             S.DN = reshape(mapping(lastPos+1:lastPos+tri),tri,1);
%             lastPos = lastPos+tri;
%         end
%         PrVars = mapping(lastPos+1:end);
%         S.Pr = model.encoding_vars.Pr;
%         negVars = PrVars(PrVars<0);
%         for negVpos = 1:length(negVars)
%             S.Pr(S.Pr==abs(negVars(negVpos))) = negVars(negVpos);
%         end
%         end
%     % else
%     %     S = nan;
%         solution.Map = Map;
% end
% end
end