% addpath(genpath('~/workspace/Documents/uni/sc/matlab/satnerv/'));
% addpath(genpath('~/workspace/Documents/uni/sc/matlab/drtoolbox/'));
%% generate data
actData = 'helix';
N=100;rng(100);
t = (1:N) / N;t = t .^ (1.0) * 2 * pi;noise = 0.05;
X = [(2 + cos(8 * t')) .* cos(t') (2 + cos(8 * t')) .* sin(t') sin(8 * t')] + noise * randn(N, 3);
c_X = rem(round(t * 1.5), 2);
nb_samples = length(c_X);
% figure(2);scatter3(X(:,1),X(:,2),X(:,3),20,t,'filled');view(-25,65);
%% build the neighborhood based on the t-SNE perplexity measure
perplexity = 5;thres = 0.17;
P = x2p_own(X,perplexity)';
[sortP,sortPIDX] = sort(P,'descend');
[useRow,useCol] = find(sortP>thres);
neighborhoods = cell(1,nb_samples);
for i=1:nb_samples
    actSample = find(useCol==i);
    neighborhoods{i} = sortPIDX(useRow(actSample),i);
end
infostr = sprintf('samples %i',nb_samples);
preserveNeighborSTR = ['Per',num2str(perplexity),'thres',strrep(num2str(thres),'.','_')];
W = zeros(nb_samples,nb_samples);% W(1:(nb_samples+1):nb_samples*nb_samples) = 0;
Pr = nan(nb_samples,nb_samples);
nonNeighborhoods = cell(1,N);
for i=1:nb_samples
    js = neighborhoods{i};
    W(i,P(:,i)>thres) = P(P(:,i)>thres,i);
    nonNeighborhoods{i} = find((P(:,i)<=thres & P(:,i)>0));
    Pr(i,nonNeighborhoods{i}) = P(nonNeighborhoods{i},i);
%     W(i,js) = 1;W(js,i) = 1;
end
nPr = Pr-max(max(Pr));
nPrsum = arrayfun(@(x) sum(nPr(x,nPr(x,:)<0)) ,1:N)';
nPr = nPr./-repmat(nPrsum,1,N);
nPr(isnan(nPr))=0;

nc = arrayfun(@(x) sum(W(x,W(x,:)>0 & W(x,:)~=Inf)),1:N)';
nW = W./repmat(nc,1,N);

W = nW+nPr;
% user hard constraints
W(1,2) = Inf;W(2,1) = Inf;
% test case for same position prevention
% W = ones(5);W = W-diag(ones(1,5));W(3,5) = 0;W(5,3) = 0;
%% print some information
nn_sizes = unique(cellfun(@(x) length(x),neighborhoods));
nnn_sizes= unique(cellfun(@(x) length(x),nonNeighborhoods));
fprintf('Neighborhood sizes from %i to %i\n',min(nn_sizes),max(nn_sizes));
fprintf('NonNeighborhood sizes from %i to %i\n',min(nnn_sizes),max(nnn_sizes));
%% fix some points in the grid as hard constraints [point, position]
fixed = [];
% fixed = [1,34;50,479];
% bits_grid([2^3 2^2],10,16,[0.08 0.03 0.90 0.94]);% bits_grid(gridlength,54,20,[0.02 0.03 0.97 0.94]);
%% parameter for SATNeRV
gridlength = [16 32];
useSolver = '';
% useSolver = 'eval13MaxHS_noninteger';
mypath = mfilename('fullpath');mypath = mypath(1:end-12);
resultDir = sprintf('%sresults/%s_%i/',mypath,actData,N);
fileStr = sprintf('n%ixg%i_%s%s',nb_samples,prod(gridlength),preserveNeighborSTR,useSolver);
if(~isdir(resultDir))
    mkdir(resultDir);
end
solPath = resultDir;
cnfPath = resultDir;
samePosi = 0;
%% compute the model
% ./eval13MaxHS_noninteger ~/workspace/Documents/uni/2013/Paper/sat_nerv/results/helix_100/n100xg1024_9NNgrid_Per5thres0_17_MaxHSeval13.wcnf > test.sol
if isempty(fixed)
model = wsatnerv(W,'gridlength',gridlength,'useSolver',useSolver,'solPath',solPath,'cnfPath',cnfPath,'fileStr',fileStr,'samePosi',samePosi);
else
model = wsatnerv(W,'gridlength',gridlength,'fixed',fixed,...
                   'useSolver',useSolver,'solPath',resultDir,'cnfPath',resultDir,'fileStr',fileStr,'samePosi',samePosi);
end
save([resultDir,fileStr],'model','W','gridlength','useSolver','preserveNeighborSTR','actData','fileStr','resultDir','N');
%% run the weighted maxSAT solver
% mypath = mfilename('fullpath');
% mypath = mypath(1:end-8);
mypath = pwd;
solutionfile = [solPath,'/',fileStr,'.sol'];
system([mypath,'/./eval13MaxHS_noninteger ',model.cnfFile,' > ',solutionfile]);
%% read the solution
disp(['Read the solution ',solutionfile]);
if(length(gridlength)>1)
    nb_rows = gridlength(1);
    nb_cols = gridlength(2);
else
    nb_rows = gridlength;
    nb_cols = gridlength;
end
gridpositions = nb_rows*nb_cols;
model.solution = wsatnerv_readSolution(solutionfile, model);
model.Map = zeros(nb_samples,prod(gridlength));
for acti=1:nb_samples
    findSample = (model.solution.variables(model.Vars.pointBits(acti,:))>0)*2-1;
    model.Map(acti,arrayfun(@(x) isequal(model.Vars.bitPos(x,:),findSample),1:gridpositions)) = 1;
end
save([resultDir,fileStr],'model','W','gridlength','useSolver','preserveNeighborSTR','actData','fileStr','resultDir','N');
fprintf('%s_%ix%i time %.3fs (%i/%i) not satisfied: %i\n',actData,nb_samples,prod(gridlength),model.solution.cputime,model.cnf_info.nb_vars,model.cnf_info.nb_clauses,model.solution.notSatisfiedClauses);
%% draw the grid
Map = model.Map;
tt = 1:length(c_X);
Y = model.Grid;
shapex = [-1  1 1 -1]*0.5;
shapey = [-1 -1 1 1]*0.5;
fontweight = 'bold';
fontsize = 7;
width=28;height=16;
f = figure(1);clf(f);
set(f, 'color', 'white','units','centimeters');
set(f,'units','centimeters');scrsz=get(0,'screensize');
set(f, 'color', 'white','position',[scrsz(3)/2+width*2 scrsz(4)/2+height/2 width height]);
subplot('Position',[0.055 0.055 0.9 0.9]);hold on;box on;% axis square;
actLabels = tt;
positions = length(Y);gridposis = 1:positions;
nb_samples = length(actLabels);
actSetting = ['_',num2str(nb_samples),'x',num2str(positions)];

[mapPoint,mapPosi] = find(Map>0);
ylim([0.5,max(Y(:,2))+0.5]);xlim([0.5,max(Y(:,1))+0.5]);
for i=1:length(Y)
    actPoints = mapPoint(mapPosi==i);  
    if ~isempty(actPoints)
arrayfun(@(x) fill(Y(i,1)+shapex,Y(i,2)+shapey,actLabels(actPoints(x)),'EdgeColor',[0.5,0.5,0.5],'FaceAlpha',0.4),1:length(actPoints));
    else
        fill(Y(i,1)+shapex,Y(i,2)+shapey,[1 1 1],'FaceColor','w','EdgeColor',[0.5,0.5,0.5],'FaceAlpha', 0.1);
    end    
end
pointsOnPosi = arrayfun(@(x) sprintf('%i,',mapPoint(mapPosi==x)),unique(mapPosi),'uni',0);
% text(Y(:,1),Y(:,2),arrayfun(@(x) sprintf('%i',x),1:prod(model.Vars.grid),'uni',0)');
text(Y(unique(mapPosi),1),Y(unique(mapPosi),2),pointsOnPosi,'fontsize',fontsize,'FontWeight',fontweight,'VerticalAlignment','middle','color','r','HorizontalAlignment','center');
title(['(variables:',num2str(model.cnf_info.nb_vars),' / clauses:',num2str(model.cnf_info.nb_clauses),') ',num2str(size(X,1)),' samples: cpu time ',num2str(model.solution.cputime),' and ',num2str(model.solution.notSatisfiedClauses),' not satisfied clauses']);