#ifndef DATASET_H_
#define DATASET_H_
#include <map>
#include <set>
#include <string>
#include "Tree.h"

using namespace std;
 
enum VarType{VAR_CLIENT, VAR_FEATURE}; // The two kinds of sampling variables: Client paths and binary features.

class DataSet
{
public:
	DataSet(int nClients, int nFeatures, int treeDepth, int burnIn, int nIter, int nIterGamma, ClientInitType clientInitType,
			double k0, double alpha, double beta, double aGamma, double bGamma, double aV, double bV,
			string exprFn, string clientsFn, string featuresFn, string resultsDir, int nFeatureScans);
	~DataSet();
	void runSampler();	

	// Basic tree properties and input data.
	int nClients_, nFeatures_, treeDepth_;	
	int burnIn_, nIter_, nIterGamma_; // Number of overall Gibbs scans; number of Gibbs iterations when sampling gamma.
	int nFeatureScans_; // In each Gibbs scan, how many times should each binary feature be sampled?	 
	ClientInitType clientInitType_; // How to initialize the tree structure.	
	// Expression matrix stored in column-major form. Y(i,j) (i-th row, j-th column) corresponds to the i-th feature, j-th client.	
	double *Y_;
	// Hyperparameters.
	double k0_; 
	double alpha_, beta_; // Hyperparameters for Beta distribution used in feature activation model.
	double aGamma_, bGamma_; // Hyperparameters for gamma hyperparameter used in the nCRP.
	double aV_, bV_; // Hyperparameters for each Gamma-distributed variance.
	string resultsDir_;
	// Labels for each client and feature.
	map<int,string> indexToFeatureLabel_;
	map<int,string> indexToClientLabel_;

private:
	void parseData(string exprFn, string clientsFn, string featuresFn);	
	void writeResults(double *logProbGamma, double *logProbNcrp, double *logProbFeatures, double *logProbExpr, int *numNodes, 
		double *gammaSamples, double *accRateClients, double *accRateFeatures, Tree *mode);
	/*Tree * runSamplerAux(int treeDepth, int fold, 
		double *logProbGamma, double *logProbB, double *logProbNcrp, double *logProbFeatures, double *logProbExpr, double *logPredProb, 
		int *numNodes, double *gammaSamples, double *bSamples, double *accRateClients, double *accRateFeatures);*/
	Tree * runSamplerAux(double *logProbGamma, double *logProbNcrp, double *logProbFeatures, double *logProbExpr, int *numNodes, 
		double *gammaSamples, double *accRateClients, double *accRateFeatures);				
};

#endif /*DATASET_H_*/
