#ifndef GROUP_H_
#define GROUP_H_
#include <set>
#include <map>
#include <gsl/gsl_rng.h>

using namespace std;

class Group
{
public:	
	Group(const set<int> * includedClients,	int feature, int nFeatures, double* Y, double k0, double a, double b);
	Group(Group *group);
	~Group();	
	int nClients();	
	void addClient(int client, double value);
	bool removeClient(int client);	
	double logJointProb();	
	double logPredProb(double value);		
		
	set<int> includedClients_;
	map<int,double> clientToExpr_;
	int feature_, nFeatures_;
	double k0_; // Multiplicative parameter for the variance of the Gaussian distribution of mu (see equations). 
	double a_, b_; // Parameters for inverse-Gamma distribution.
	// Flags.
	bool recomputeMeanIncluded_;	
	bool recomputeQuadFormIncluded_;	
private:	
	double meanIncluded();
	double quadFormIncluded();		
};

#endif /*GROUP_H_*/
