#include "SamplingUtils.h"
#include <iostream>
#include <ctime>
#include <cmath>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_sf_gamma.h>
#include <gsl/gsl_rng.h>

using namespace std;

SamplingUtils::SamplingUtils()
{
}

SamplingUtils::~SamplingUtils()
{	
}

void SamplingUtils::cleanUpOnExit()
{	
	gsl_rng_free(r_);
}

// Sample one number in {0,...,n-1} from a uniform distribution. 
int SamplingUtils::uniformSample(int n)
{
	double* p = new double[n];
	int i, out;
	for(i = 0; i < n; i++)
		p[i] = 1.0/n;
	gsl_ran_discrete_t* table = gsl_ran_discrete_preproc(n, p);
	out = gsl_ran_discrete(r_, table);
	delete [] p;
	gsl_ran_discrete_free(table);
	return out;
}

int SamplingUtils::discreteSample(int n, double* p)
{
	int out;
	gsl_ran_discrete_t* table = gsl_ran_discrete_preproc(n, p);
	out = gsl_ran_discrete(r_, table);
	gsl_ran_discrete_free(table);
	return out;
}

int SamplingUtils::sampleFromLogRatio(double logRatio)
{
	double ratio = exp(logRatio);	
	double prob = ratio / (1 + ratio);
	return gsl_ran_bernoulli(r_, prob);			
}

void SamplingUtils::initRng()
{
	r_ = gsl_rng_alloc(gsl_rng_taus2);
	gsl_rng_set(r_, (unsigned long int) time(NULL)); // Set random seed.
}

gsl_rng* SamplingUtils::r_;
