#ifndef TREE_H_
#define TREE_H_
#include <string>
#include <queue>
#include <stack>
#include <map>
#include <set>
#include <utility> // For pair.
#include "FeatureNode.h"
#include "Group.h"

enum ClientInitType{INIT_ONE_PER_LEAF, INIT_NCRP};

class Tree
{
public:
	Tree();
	Tree(int nClients, int nFeatures, int treeDepth, double* expr, ClientInitType clientInitType, int nIterGamma,  
		double k0, double alpha, double beta, double aGamma, double bGamma, double aV, double bV);	
	Tree(Tree *tree);	
	~Tree();	
	void sampleGamma(double *gammaValues);				
	bool sampleClient(int client, double *expr); // Return true iff new path is different from old path. 
	bool sampleFeature(int feature, double *expr); // Return true iff new feature value is different from old feature value.
	double logProbGamma();
	double logProbB();
	double logProbNcrp(FeatureNode* node);	
	double logProbFeatures();
	double logProbExpr(double *expr);				
	void writeToFile(string stem, map<int,string> *indexToClientLabel, map<int,string> *indexToFeatureLabel);
	int nNodes();
	int nLeafNodes();
				
	int nClients_, nFeatures_, treeDepth_;	
	int nIterGamma_; // Number of Gibbs sampler iterations when sampling gamma (only last sample is collected).	
	double k0_, alpha_, beta_, aGamma_, bGamma_, aV_, bV_, gamma_;
	FeatureNode* root_; // Entry point to tree.
	map<FeatureNode*,FeatureNode*> nodeToParent_;
	map<FeatureNode*, set<FeatureNode*>* > nodeToChildren_;
	map<pair<FeatureNode*,FeatureNode*>,double> edgeLength_;
	map<FeatureNode*, bool> nodeIsLeaf_;
	map<FeatureNode*, int> nodeToLevel_;
	map<FeatureNode*, queue<FeatureNode*>*> nodeToTempPath_;
	map<int, FeatureNode*> clientToLeafNode_;
	
private:
	void destructorAux(FeatureNode* node);
	void initRoot(double* expr);
	void onePerLeafAddClients(double *expr);
	void ncrpAddClients(double *expr);	
	void addClients(double* expr, ClientInitType clientInitType);
	void removeClientAux(int client, FeatureNode *node);
	void removeClient(int client);
	double addReplicatedTemporaryPath(int client, FeatureNode* node, double *expr, stack<FeatureNode*> oldPath);
	double addTemporaryPath(int client, FeatureNode *node, double *expr);
	void cancelTemporaryPath(FeatureNode *node);
	void commitTemporaryPath(int client, FeatureNode *node, double *expr);	
	int samplePathKeptIn(int client, double *expr, double *prob, FeatureNode *node, int nodeIndex,   
						map<int, FeatureNode*>* indexToNode, double accLogPathProb, double accLogExprProb, stack<FeatureNode*> oldPath);
	bool sampleFeatureAuxPositive(FeatureNode* node, int feature, double *expr);
	bool sampleFeatureAuxNegative(FeatureNode* node, int feature, double *expr);
	void randomFeatureNodeAux(FeatureNode* node, int feature, vector<FeatureNode*>* nodes);
	FeatureNode* randomFeatureNode(int feature);
	double logProbFeaturesSingleNode(FeatureNode *node);
	void computeNodeToNChildren(map<FeatureNode*, int> *nodeToNChildren);
	int computeNodeToNClients(map<FeatureNode*, int> *nodeToNClients, FeatureNode* node);	
	void clientPathAux(int client, FeatureNode *node, stack<FeatureNode*> *s);
	stack<FeatureNode*> clientPath(int client);
	bool pathHasChanged(stack<FeatureNode*> oldPath, FeatureNode *newNode);
	void estimateEdgeLengths();
};

#endif /*TREE_H_*/
