#include <iostream>
#include <string>
#include <cstdlib>
#include <getopt.h>
#include "Tree.h"
#include "SamplingUtils.h"
#include "Group.h"
#include "DataSet.h"
#include "utils.h"

using namespace std;
			
void printArgs(int nClients, int nFeatures, int treeDepth, int burnIn, int nIter, int nIterGamma, ClientInitType clientInitType, 
				double alpha, double beta, double aGamma, double bGamma, double aV, double bV, 
				string exprFn, string clientsFn, string featuresFn, string resultsDir, int nFeatureScans)
{
	cout << "Arguments: " << endl << endl;
	cout << "nClients: " << nClients << endl;
	cout << "nFeatures: " << nFeatures << endl;
	cout << "treeDepth: " << treeDepth << endl;
	cout << "burnIn: " << burnIn << endl;	
	cout << "nIter: " << nIter << endl;
	cout << "nIterGamma: " << nIterGamma << endl;	
	cout << "clientInitType: " << clientInitType << endl;	
	cout << "alpha: " << alpha << endl;
	cout << "beta: " << beta << endl;
	cout << "a gamma: " << aGamma << endl;
	cout << "b gamma: " << bGamma << endl;	
	cout << "a V: " << aV << endl;
	cout << "b V: " << bV << endl;
	cout << "exprFn: " << exprFn << endl;
	cout << "clientsFn: " << clientsFn << endl;	
	cout << "featuresFn: " << featuresFn << endl;
	cout << "resultsDir: " << resultsDir << endl;	
	cout << "nFeatureScans: " << nFeatureScans << endl;
}

int main(int argc, char* argv[])
{		
	char ch;		
	int nClients, nFeatures, treeDepth, burnIn, nIter, nIterGamma, nFeatureScans, clientTemp;
	double k0, alpha, beta, aGamma, bGamma, aV, bV;
	string exprFn, clientsFn, featuresFn, resultsDir;
	
	ClientInitType clientInitType;
	
	// Variables initialized to dummy values only to prevent compiler warnings.
	nClients = nFeatures = treeDepth = burnIn = nIter = nIterGamma = nFeatureScans = clientTemp = 0;
	k0 = alpha = beta = aGamma = bGamma = aV = bV = 0.0;
	clientInitType = INIT_NCRP;
	
	SamplingUtils::initRng(); // Allocate and initialize random number generator.

	struct option longopts[] = {
		{"nClients", required_argument, NULL, 1 },
		{"nFeatures", required_argument, NULL, 2 },
		{"treeDepth", required_argument, NULL, 3},
		{"burnIn", required_argument, NULL, 4},
		{"nIter", required_argument, NULL, 5},
		{"nIterGamma", required_argument, NULL, 6},
		{"clientInitType", required_argument, NULL, 7},		
		{"alpha", required_argument, NULL, 8},
		{"beta", required_argument, NULL, 9},
		{"aGamma", required_argument, NULL, 10},
		{"bGamma", required_argument, NULL, 11},		
		{"aV", required_argument, NULL, 12}, 		
		{"bV", required_argument, NULL, 13},
		{"exprFn", required_argument, NULL, 14},
		{"clientsFn", required_argument, NULL, 15},
		{"featuresFn", required_argument, NULL, 16},
		{"resultsDir", required_argument, NULL, 17},		
		{"nFeatureScans", required_argument, NULL, 18},
		{NULL, 0, NULL, 0}
	};	
	
	while((ch = getopt_long(argc, argv, "", longopts, NULL)) != -1)
		switch(ch){
			case 1: nClients = atoi(optarg); break;
			case 2: nFeatures = atoi(optarg); break;
			case 3: treeDepth = atoi(optarg); break;
			case 4: burnIn = atoi(optarg); break;			
			case 5: nIter = atoi(optarg); break;
			case 6: nIterGamma = atoi(optarg); break;
			case 7: clientTemp = atoi(optarg); clientInitType = (clientTemp == 0?INIT_ONE_PER_LEAF:INIT_NCRP); break;
			case 8: alpha = atof(optarg); break;
			case 9: beta = atof(optarg); break;
			case 10: aGamma = atof(optarg); break;
			case 11: bGamma = atof(optarg); break;			
			case 12: aV = atof(optarg); break;
			case 13: bV = atof(optarg); break;
			case 14: exprFn = optarg; break;
			case 15: clientsFn = optarg; break;
			case 16: featuresFn = optarg; break;
			case 17: resultsDir = optarg; break;					
			case 18: nFeatureScans = atoi(optarg); break;
		}
	
	// Multiplicative parameter related to the normal-Gamma model used for generating the expression data.
	// Set to 1 in the paper. 	
	k0 = 1;
	
	printArgs(nClients, nFeatures, treeDepth, burnIn, nIter, nIterGamma, clientInitType,
				alpha, beta, aGamma, bGamma, aV, bV,  
				exprFn, clientsFn, featuresFn, resultsDir, nFeatureScans);
			
	DataSet dataSet(nClients, nFeatures, treeDepth, burnIn, nIter, nIterGamma, clientInitType,
					k0, alpha, beta, aGamma, bGamma, aV, bV,
					exprFn, clientsFn, featuresFn, resultsDir, nFeatureScans);
				
	dataSet.runSampler();	
	SamplingUtils::cleanUpOnExit(); // Free random number generator.
	return 0;	
}
