#include "utils.h"
#include "SamplingUtils.h"
#include <string>
#include <fstream>
#include <iostream>
#include <gsl/gsl_sf_gamma.h>
#include <cmath>
#include <queue>

using namespace std;

// Get linear index to a matrix stored in column-major form.
// The expression matrix is (nGenes_, nConds_), so that each 
// condition has consecutive features.  
int getIndex(int row, int col, int nRows)
{
	return col * nRows + row;
}

// Randomly split numbers from 0 to (nObjects - 1) into nPartitions partitions.
// Partitions are numbered from 0 to (nPartitions - 1).
// Write the assignments to a file.
void partition(int nObjects, int nPartitions, string filename)
{
	ofstream file(filename.c_str());
	int i, partition;
	for(i = 0; i < nObjects; i++){
		// Randomly assign object to a partition. 
		partition = SamplingUtils::uniformSample(nPartitions);
		file << i << "\t" << partition << endl;
	}
}

double stdNormLogProb(double val)
{
	return -0.5 * (log(2 * M_PI) + pow(val, 2.0)); 	
}

double tLogProb(double df, double location, double scale, double y)
{	
	double out = gsl_sf_lngamma((df+1)/2);
	out -= gsl_sf_lngamma(df/2);
	out -= 0.5 * log(location * M_PI) + log(scale);
	out -= (df+1)/2 * log(1 + 1/df * pow((y-location)/scale , 2.0));
	return out;
}

double inverseGammaPdf(double val, double a, double b)
{
	double lnOut = 0.0;
	lnOut += -b / val;
	lnOut += (- a - 1) * log(val);
	lnOut += a * log(b);
	lnOut -= gsl_sf_lngamma(a);	
	return exp(lnOut);
}
