#ifndef FEATURENODE_H_
#define FEATURENODE_H_
#include <set>
#include <map>
#include "Group.h"

using namespace std;

class FeatureNode{
public:
	
	FeatureNode(const set<int> * includedClients, const set<int>* newFeatures, const set<int>* nullFeatures, 
				double* expr, int nFeatures, double k0, double a, double b);
	FeatureNode(FeatureNode *node);
	~FeatureNode(void);
			
	int nClients();
	int nNewFeatures();
	int nNullFeatures();	
	void addClient(int client, double *expr);
	bool removeClient(int client);
		
	set<int> includedClients_;	
	set<int> newFeatures_;	// Features that switched to 1 since parent node.
	set<int> nullFeatures_;	// Features that stayed at 0 since parent node.
	map<int,Group*> newFeatureToGroup_; // Groups induced by switching a feature from 0 to 1.
	int nFeatures_;	// Total number of features in the data set. May be greater than the size of newFeatures_ + the size of nullFeatures_. 
};

#endif /*FEATURENODE_H_*/
