#!/bin/sh

# Example of how to run treebic.

nClients=50
nFeatures=20
treeDepth=3
burnIn=5
nIter=1000 # Number of iterations after the burn-in phase.
nIterGamma=100 # Number of iterations when sampling gamma.
# clientInitType=1 means initialize tree to sample from nCRP prior. 
# clientInitType=0 means initialize tree by having each client occupy its own leaf.
# Notice that only by choosing the nCRP initialization we are able to introduce variation in the initial structure 
# between different Gibbs sampler runs.
clientInitType=1
alpha=1 # Hyperparameter for edge length Beta prior.
beta=1 # Hyperparameter for edge length Beta prior.
aGamma=1 # Hyperparameter for Gamma prior of gamma.
bGamma=1 # Hyperparameter for Gamma prior of gamma.
aV=1 # Hyperparameter for Gamma prior in variance variable within each induced group.
bV=1 # Hyperparameter for Gamma prior in variance variable within each induced group.
exprFn="expression_data.txt"
clientsFn="client_labels.txt"
featuresFn="feature_labels.txt"
resultsDir="results/"
nFeatureScans=5

../treebic --nClients $nClients --nFeatures $nFeatures --treeDepth $treeDepth --burnIn $burnIn --nIter \
$nIter --nIterGamma $nIterGamma --clientInitType $clientInitType --alpha $alpha --beta $beta \
--aGamma $aGamma --bGamma $bGamma --aV $aV --bV $bV --exprFn $exprFn --clientsFn $clientsFn \
--featuresFn $featuresFn --resultsDir $resultsDir --nFeatureScans $nFeatureScans
