#ifndef UTILS_
#define UTILS_
#include <fstream>
#include <iostream>
#include <string>

using namespace std;

// Get linear index to a matrix stored in column-major form.
// The expression matrix is (nGenes_, nConds_), so that each 
// condition has consecutive features.  
int getIndex(int row, int col, int nRows);

void partition(int nObjects, int nPartitions, string filename);

double stdNormLogProb(double val);

double tLogProb(double df, double location, double scale, double y);

double inverseGammaPdf(double val, double a, double b);

// Print a matrix stored in column-major order. 
template<typename T> void printMatrix(T *Y, int nRow, int nCol, string filename)
{
	ofstream out(filename.c_str());
	int i, j;
	for(i = 0; i < nRow; i++){
		for(j = 0; j < nCol; j++)
			out << Y[getIndex(i,j,nRow)] << " ";
		out << endl;		
	}
}

#endif /*UTILS_*/
