#include "FeatureNode.h"
#include "Group.h"
#include "utils.h"
#include <set>
#include <map>

using namespace std;

// Cannot be used to build a node with 0 clients. 
FeatureNode::FeatureNode(const set<int> * includedClients, const set<int>* newFeatures, const set<int>* nullFeatures, 
		double* expr, int nFeatures, double k0, double a, double b)
: includedClients_(*includedClients), newFeatures_(*newFeatures), nullFeatures_(*nullFeatures), nFeatures_(nFeatures)
{
	if(includedClients->size() == 0)
		cerr << "FeatureNode: Cannot build node with 0 clients." << endl;			
	else{
		set<int>::iterator fit; // Feature iterator.
		for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)
			newFeatureToGroup_[*fit] = new Group(includedClients, *fit, nFeatures, expr, k0, a, b);					
	}
}

FeatureNode::FeatureNode(FeatureNode* node)
:includedClients_(node->includedClients_), newFeatures_(node->newFeatures_), nullFeatures_(node->nullFeatures_), nFeatures_(node->nFeatures_)
{
	set<int>::iterator fit; // Feature iterator.	 
	for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)		
		newFeatureToGroup_[*fit] = new Group(node->newFeatureToGroup_[*fit]); // Make a copy of each group.
}

FeatureNode::~FeatureNode(void)
{	
	set<int>::iterator fit;	// Feature iterator.				
	for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)
		delete newFeatureToGroup_[*fit]; // Delete groups associated with active features.	
}

int FeatureNode::nClients(){return includedClients_.size();}
int FeatureNode::nNewFeatures(){return newFeatures_.size();}
int FeatureNode::nNullFeatures(){return nullFeatures_.size();}

// If the client already exists, do nothing.
void FeatureNode::addClient(int client, double *expr)
{
	set<int>::iterator fit; // Feature iterator.
	// If the client already exists, do nothing.
	if(includedClients_.find(client) != includedClients_.end())
		return;	   
	includedClients_.insert(client);	
	for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)
		newFeatureToGroup_[*fit]->addClient(client, expr[getIndex(*fit, client, nFeatures_)]);		
}

// If the number of clients drops to zero, then the node is deleted.
bool FeatureNode::removeClient(int client)
{
	int nOldClients = nClients();
	set<int>::iterator fit; // Feature iterator.	
	bool clientExisted = includedClients_.erase(client);
	if(clientExisted){
		for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)
			newFeatureToGroup_[*fit]->removeClient(client);				
		if(nOldClients == 1){
			// This ensures that when the node is deleted due to lack of clients, the groups won't be deleted twice.
			for(fit = newFeatures_.begin(); fit != newFeatures_.end(); fit++)
				// Note that the groups have already been deleted during the calls to "Group::removeClient".				 
				newFeatureToGroup_[*fit] = NULL;	
			delete this;
		}
	}
	return clientExisted;
}
