#ifndef SAMPLINGUTILS_H_
#define SAMPLINGUTILS_H_
#include <gsl/gsl_rng.h>

class SamplingUtils
{
public:				
	static int uniformSample(int n);
	static int discreteSample(int n, double* p);
	static int sampleFromLogRatio(double logRatio);
	static void cleanUpOnExit();
	static void initRng();
	static gsl_rng* r_; // Random number generator.
private:
	SamplingUtils();
	~SamplingUtils();
};

#endif /*SAMPLINGUTILS_H_*/
